/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.replace;

import com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceFRUBean;
import com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceHardwareConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PIFrame;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.ReplacePartsTarget;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruGuiInfo;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.tasklet.ServiceActionDriverTasklet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ReplaceFRUTasklet
extends TargetedTasklet
implements ReplaceHardwareConstants {
    private static final String TRACE_MASKD = "JRPFRTKD";
    private static final String TRACE_MASKF = "JRPFRTKF";
    private static final String TRACE_MASKT = "JRPFRTKT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceHardware";
    private static final String INITIAL_PANEL = "ReplaceFRU1";
    private static final String SECOND_PANEL = "ReplaceFRU2";
    private static final String RV_TASKLET = "com.ibm.hwmca.xfw.service.tasklet.RepairAndVerifyTasklet";
    private static final LocalizableText BUSY_TITLE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_FRU_TITLE");
    private static final LocalizableText BUSY_CONTENT = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_FRU_TEXT");
    private static final String ENCL = "encl";
    private static final String SYS_TAG = "sys";
    public static final String UNSUPPORTED_ENCLOSURE = "unsupported_enclosure";
    private static final short ERRID_0000 = 0;
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final short ERRID_0003 = 3;
    private static final short ERRID_0004 = 4;
    private String userDefinedName = null;
    private String bpaType = null;
    private String bpaModel = null;
    private String bpaSerial = null;
    private String bpaMtms = null;
    private PIHSCCECClient r5Client = null;
    private PIHSCFrameClient r5fClient = null;
    private boolean TargetIsACec;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -127, "SFPRemHW");

    public ReplaceFRUTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> ReplaceFRUTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        block48: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.service()");
            if (panelTaskletRequest.isInitialRequest()) {
                Trace.trace((String)TRACE_MASKF, (Object)"-> ReplaceFRUTasklet.isInitialRequest()");
                ReplaceFRUBean replaceFRUBean = new ReplaceFRUBean();
                replaceFRUBean.setBeanName("ReplaceFRUBean1");
                Target[] targetArray = this.getSelectedTargets();
                String string = targetArray[0].getName().toString();
                Object object = ((ReplacePartsTarget)targetArray[0]).getTargetObject();
                if (object instanceof PICec || object instanceof PIFrame) {
                    if (object instanceof PICec) {
                        this.userDefinedName = ((PICec)object).getUserDefinedName();
                        this.TargetIsACec = true;
                        Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a CEC");
                    } else {
                        this.userDefinedName = ((PIFrame)object).getName();
                        this.bpaType = ((PIFrame)object).getMachineType();
                        this.bpaModel = ((PIFrame)object).getModel();
                        this.bpaSerial = ((PIFrame)object).getSerialNumber();
                        this.bpaMtms = this.bpaType + "." + this.bpaModel + "." + this.bpaSerial;
                        this.TargetIsACec = false;
                        Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a Frame");
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("-- selected system is: " + string + ", user defined name is: " + this.userDefinedName));
                    if (string != null && string.length() != 0) {
                        replaceFRUBean.setSelectedSystem(string);
                    }
                    try {
                        this.showBusyDialog(BUSY_TITLE, BUSY_CONTENT);
                        this.getInstalledEnclosureInfo(replaceFRUBean, this.userDefinedName);
                        String[] stringArray = replaceFRUBean.getAllEnclosureLocCodes();
                        if (stringArray != null && stringArray.length > 0) {
                            String[] stringArray2 = this.getListOfEnclosureTypes(stringArray, replaceFRUBean);
                            String[] stringArray3 = null;
                            String[] stringArray4 = null;
                            Integer[] integerArray = replaceFRUBean.getAllEnclosureIndexes();
                            Integer[] integerArray2 = null;
                            if (stringArray2 != null && stringArray2.length > 0) {
                                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                ArrayList<String> arrayList3 = new ArrayList<String>();
                                arrayList.add(integerArray[0]);
                                arrayList2.add(stringArray[0]);
                                arrayList3.add(stringArray2[0]);
                                Trace.trace((String)TRACE_MASKF, (Object)("enclosure type, " + stringArray2[0] + ", added to array"));
                                for (int i = 1; i < stringArray2.length; ++i) {
                                    if (arrayList3.contains(stringArray2[i])) {
                                        Trace.trace((String)TRACE_MASKF, (Object)("enclosure type, " + stringArray2[i] + ", already included in array"));
                                        continue;
                                    }
                                    Trace.trace((String)TRACE_MASKF, (Object)("new enclosure type, " + stringArray2[i] + ", added to display array"));
                                    arrayList.add(integerArray[i]);
                                    arrayList2.add(stringArray[i]);
                                    arrayList3.add(stringArray2[i]);
                                }
                                integerArray2 = arrayList.toArray(new Integer[arrayList.size()]);
                                stringArray3 = arrayList2.toArray(new String[arrayList2.size()]);
                                stringArray4 = arrayList3.toArray(new String[arrayList3.size()]);
                                replaceFRUBean.setUniqueInstalledEnclosureIndexes(integerArray2);
                                replaceFRUBean.setUniqueInstalledEnclosureLocCodes(stringArray3);
                                replaceFRUBean.setUniqueInstalledEnclosureTypes(stringArray4);
                            }
                        }
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)replaceFRUBean);
                        this.destroyBusyDialog();
                    }
                    catch (Exception exception) {
                        String string2;
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception during initial service request, e is " + exception));
                        this.destroyBusyDialog();
                        new AusMicrocodeLog(_logInfo, 1, exception).writeEntry(null);
                        if (exception.getMessage().equals("CIMNullClient")) {
                            string2 = "0242";
                        } else if (exception.getMessage().equals("CIMBadClient")) {
                            string2 = "0243";
                        } else if (exception instanceof UnknownHostException) {
                            string2 = "0241";
                        } else if (exception instanceof PIHscClientException) {
                            String string3 = ((PIHscClientException)exception).getMsgId();
                            Trace.trace((String)TRACE_MASKF, (Object)("-- PIHscClientException msg ID is " + string3));
                            string2 = "0238";
                        } else {
                            string2 = "0245";
                        }
                        SFPUtil.showSFPErrorMessageBox(string2, (PanelTasklet)this);
                        try {
                            panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)replaceFRUBean);
                        }
                        catch (Exception exception2) {
                            Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                            panelTaskletResponse.terminate();
                        }
                    }
                } else {
                    panelTaskletResponse.noAction();
                }
                Trace.trace((String)TRACE_MASKF, (Object)"<- ReplaceFRUTasklet.isInitialRequest()");
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(command): " + panelTaskletRequest.getData("Command") + "."));
                if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                    Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                    panelTaskletResponse.dispose();
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                    String string = (String)panelTaskletRequest.getData("Command");
                    ReplaceFRUBean replaceFRUBean = (ReplaceFRUBean)panelTaskletRequest.getData("DataBean");
                    Trace.trace((String)TRACE_MASKF, (Object)("command is " + string));
                    if (string == null) {
                        panelTaskletResponse.noAction();
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("Command", string);
                    hashMap.put("DataBean", replaceFRUBean);
                    if (string.equals("queryFRUs")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Query FRUs request found tasklet side.");
                        String string4 = (String)panelTaskletRequest.getData("KeyData");
                        try {
                            if (this.is_a_supported_enclosure(string4, replaceFRUBean)) {
                                Trace.trace((String)TRACE_MASKF, (Object)"supported enclosure type, list of FRUs to be added...");
                                String[] stringArray = this.getValidFruTypes(string4, replaceFRUBean);
                                hashMap.put("KeyData", stringArray);
                                panelTaskletResponse.update(replaceFRUBean.getBeanName(), hashMap);
                                break block48;
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)"Unsupported enclosure type, no FRUs to be supported.");
                            hashMap.put("KeyData", new String[0]);
                            panelTaskletResponse.update(replaceFRUBean.getBeanName(), hashMap);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught while querying FRUs for given enclosure, e is " + exception));
                            Trace.trace((String)TRACE_MASKF, (Object)exception);
                            panelTaskletResponse.noAction();
                        }
                    } else if (string.equals("populateTable")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Populate location code table request found tasklet side.");
                        String string5 = (String)panelTaskletRequest.getData("KeyData");
                        try {
                            this.populateFRULocCodeTable(replaceFRUBean);
                            panelTaskletResponse.update(replaceFRUBean.getBeanName(), hashMap);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught while populating the 'Available FRU' table, e is " + exception));
                            Trace.trace((String)TRACE_MASKF, (Object)exception);
                            panelTaskletResponse.noAction();
                        }
                    } else if (string.equals("CommitButton")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Commit button found tasklet side.");
                        try {
                            ReplaceFRUBean replaceFRUBean2 = (ReplaceFRUBean)panelTaskletRequest.getData("DataBean");
                            this.launchRepair(panelTaskletResponse, replaceFRUBean);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is" + exception));
                            Trace.trace((String)TRACE_MASKF, (Object)exception);
                        }
                    } else if (string.equals("PreviousButton")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Previous button pressed");
                        try {
                            PanelTaskletRequest panelTaskletRequest2 = new PanelTaskletRequest();
                            panelTaskletRequest2.setData("DataBean", (Object)replaceFRUBean);
                            panelTaskletRequest2.setData("Command", (Object)"refreshBean");
                            this.postRequest("ReplaceFRUBean1", panelTaskletRequest2);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("exception caught attempting to post a new tasklet request, e is " + exception));
                        }
                        panelTaskletResponse.dispose();
                    } else if (string.equals("NextButton")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Next button pressed");
                        replaceFRUBean.setBeanName("ReplaceFRUBean2");
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, SECOND_PANEL, (PanelBean)replaceFRUBean);
                    } else if (string.equals("refreshBean")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"caught the refresh command posted from 2nd dialog...");
                        panelTaskletResponse.update("ReplaceFRUBean1", hashMap);
                    } else {
                        Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to ReplaceFRUTasklet.");
                        panelTaskletResponse.noAction();
                    }
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.service()");
    }

    public void getInstalledEnclosureInfo(ReplaceFRUBean replaceFRUBean, String string) throws Exception {
        block11: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.getAllEnclosureInfo()");
            try {
                if (this.r5Client == null || this.r5fClient == null) {
                    if (this.TargetIsACec) {
                        this.r5Client = this.createCECClient(string);
                    } else {
                        this.r5fClient = this.createFrameClient(string);
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client value should now be set");
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client instance has already been set");
                }
                if (this.r5Client != null || this.r5fClient != null) {
                    try {
                        if (this.TargetIsACec) {
                            this.getAllCecSysInfo(this.r5Client, replaceFRUBean);
                        } else {
                            this.getAllFrameSysInfo(this.r5fClient, replaceFRUBean);
                        }
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getAllCecSysInfo()/getAllFrameSysInfo() completed successfully");
                        break block11;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getAllCecSysInfo()/getAllFrameSysInfo(), exception is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        new AusMicrocodeLog(_logInfo, 2, exception).writeEntry(null);
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client creation returned null");
                new AusMicrocodeLog(_logInfo, 3).writeEntry(null);
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                new AusMicrocodeLog(_logInfo, 4).writeEntry(null);
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.getAllEnclosureInfo()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw new Exception("CIMBadClient");
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    private PIHSCFrameClient createFrameClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.createFrameClient()");
        PIHSCFrameClient pIHSCFrameClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                Trace.trace((String)TRACE_MASKD, (Object)("-- selected system name is: " + string));
                pIHSCFrameClient = pIHSCClientObjectFactory.createFrameClient(string, false);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5fClient is: " + exception));
                throw new Exception("CIMBadClient");
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.createCECClient()");
        return pIHSCFrameClient;
    }

    private void getAllCecSysInfo(PIHSCCECClient pIHSCCECClient, ReplaceFRUBean replaceFRUBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.getAllCecSysInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        try {
            String string = replaceFRUBean.getSelectedSystem();
            String string2 = string.substring(0, 4);
            String string3 = string.substring(5, 8);
            pILEDDataBean = pIHSCCECClient.getAllHardwareInfo();
            String[] stringArray = pILEDDataBean.getEnclosures();
            String[] stringArray2 = pILEDDataBean.getLocationCodes();
            Integer[] integerArray = pILEDDataBean.getLEDStatus();
            String string4 = null;
            int n = 0;
            ArrayList<String> arrayList5 = new ArrayList<String>();
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(ENCL)) {
                    string4 = stringArray2[i].substring(1, 5);
                    if (string4.equals(string2)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + i));
                    }
                    ++n;
                    arrayList3.add(new Integer(n2));
                    arrayList4.add(stringArray2[i]);
                    if (arrayList5.contains(string4)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- duplicate enclosure found : <" + string4 + ">"));
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- new enclosure found : <" + string4 + ">"));
                        arrayList5.add(string4);
                    }
                    arrayList.add(stringArray2[i]);
                    arrayList2.add(integerArray[i]);
                    ++n2;
                } else if (stringArray[i].equals(SYS_TAG)) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + i));
                } else {
                    arrayList.add(stringArray2[i]);
                    arrayList2.add(integerArray[i]);
                    ++n2;
                }
                Trace.trace((String)TRACE_MASKF, (Object)("locCode/status/index is <" + stringArray2[i] + "/" + integerArray[i] + "/" + i + ">"));
            }
            if (stringArray != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- system contains " + n + " enclosures"));
                Trace.trace((String)TRACE_MASKF, (Object)("-- system + enclosures + FRU count is " + stringArray.length));
            }
            replaceFRUBean.setInstalledLocCodes(arrayList);
            replaceFRUBean.setInstalledStatus(arrayList2);
            replaceFRUBean.setAllEnclosureIndexes(arrayList3.toArray(new Integer[arrayList3.size()]));
            replaceFRUBean.setAllEnclosureLocCodes(arrayList4.toArray(new String[arrayList4.size()]));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.getAllCecSysInfo()");
    }

    private void getAllFrameSysInfo(PIHSCFrameClient pIHSCFrameClient, ReplaceFRUBean replaceFRUBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.getAllFrameSysInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        Vector vector = null;
        try {
            block21: {
                Object object;
                Object object2;
                Object object3;
                int n;
                Object object4;
                String string = replaceFRUBean.getSelectedSystem();
                String string2 = string.substring(0, 4);
                String string3 = string.substring(5, 8);
                int n2 = 0;
                vector = pIHSCFrameClient.getAllLocationCodes();
                if (vector != null && vector.size() > 0) {
                    int n3 = 0;
                    object4 = new ArrayList();
                    n2 = 0;
                    for (n = 0; n < vector.size(); ++n) {
                        pILEDDataBean = (PILEDDataBean)vector.elementAt(n);
                        object3 = pILEDDataBean.getEnclosures();
                        String[] stringArray = pILEDDataBean.getLocationCodes();
                        object2 = pILEDDataBean.getLEDStatus();
                        object = null;
                        for (int i = 0; i < ((String[])object3).length; ++i) {
                            if (object3[i].equals(ENCL)) {
                                object = stringArray[i].substring(1, 5);
                                if (((String)object).equals(string2)) {
                                    Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + i));
                                }
                                ++n3;
                                arrayList3.add(new Integer(n2));
                                arrayList4.add(stringArray[i]);
                                if (((ArrayList)object4).contains(object)) {
                                    Trace.trace((String)TRACE_MASKF, (Object)("-- duplicate enclosure found : <" + (String)object + ">"));
                                } else {
                                    Trace.trace((String)TRACE_MASKF, (Object)("-- new enclosure found : <" + (String)object + ">"));
                                    ((ArrayList)object4).add(object);
                                }
                                arrayList.add(stringArray[i]);
                                arrayList2.add(object2[i]);
                                ++n2;
                            } else if (object3[i].equals(SYS_TAG)) {
                                Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + i));
                            } else {
                                arrayList.add(stringArray[i]);
                                arrayList2.add(object2[i]);
                                ++n2;
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)("locCode/status/index is <" + stringArray[i] + "/" + object2[i] + "/" + i + ">"));
                        }
                    }
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- no PILEDDataBeans returned from getAllLocationCodes() call.");
                }
                Object var13_15 = null;
                object4 = "U" + this.bpaMtms;
                n = 1;
                object3 = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((String)object4).equals((String)arrayList.get(i))) continue;
                    n = 0;
                    break;
                }
                Trace.trace((String)TRACE_MASKF, (Object)("-- addBPA status is <" + (n != 0) + ">"));
                if (n != 0) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- bpa location code is <" + (String)object4 + ">, enclosure index is: " + n2));
                    arrayList.add(object4);
                    arrayList2.add(new Integer(64));
                    arrayList3.add(new Integer(n2));
                    arrayList4.add(object4);
                    try {
                        FruConfig fruConfig = new FruConfig(this.bpaType, this.bpaModel);
                        object2 = fruConfig.queryEnclosureFruInfo((String)object4);
                        object = object2.values();
                        if (object != null) {
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                List list = (List)iterator.next();
                                if (list != null) {
                                    Iterator iterator2 = list.iterator();
                                    while (iterator2.hasNext()) {
                                        FruGuiInfo fruGuiInfo = (FruGuiInfo)iterator2.next();
                                        object3 = fruGuiInfo.getLocationSuffix();
                                        Trace.trace((String)TRACE_MASKF, (Object)("-- bpa FRU added to location code list, sfx is: " + (String)object3));
                                        arrayList.add((String)object4 + "-" + (String)object3);
                                        arrayList2.add(new Integer(128));
                                    }
                                    continue;
                                }
                                Trace.trace((String)TRACE_MASKF, (Object)"-- fgis is null");
                            }
                            break block21;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)"-- c is null");
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception determining FRU suffixes, e is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                    }
                }
            }
            replaceFRUBean.setInstalledLocCodes(arrayList);
            replaceFRUBean.setInstalledStatus(arrayList2);
            replaceFRUBean.setAllEnclosureIndexes(arrayList3.toArray(new Integer[arrayList3.size()]));
            replaceFRUBean.setAllEnclosureLocCodes(arrayList4.toArray(new String[arrayList4.size()]));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.getAllFrameSysInfo()");
    }

    private String[] getListOfEnclosureTypes(String[] stringArray, ReplaceFRUBean replaceFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.getListOfEnclosureTypes()");
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosureLocCodes (String[]) array size is: " + n));
        String string = replaceFRUBean.getSelectedSystem();
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 8);
        for (int i = 0; i < n; ++i) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code[" + i + "] is <" + stringArray[i] + ">"));
        }
        Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string2 + "/" + string3));
        if (n > 0) {
            String[] stringArray3 = new String[1];
            String[] stringArray4 = new String[1];
            try {
                FruConfig fruConfig = new FruConfig(string2, string3);
                for (int i = 0; i < n; ++i) {
                    try {
                        stringArray3[0] = stringArray[i];
                        Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure location code to cross reference is: " + stringArray3[0]));
                        stringArray4 = fruConfig.queryDescriptionsByLocation(stringArray3, null);
                        if (stringArray4 != null && stringArray4[0].length() > 0) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- adding enclosure description <" + stringArray4[0] + "> added to array"));
                            stringArray2[i] = stringArray4[0];
                            continue;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)"-- null or zero length description returned, adding unknown enclosure indicator");
                        stringArray2[i] = new String("unsupported_enclosure - " + stringArray3[0]);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception invoking queryDescriptionsByLocation(), ex is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        stringArray2[i] = new String("unsupported_enclosure - " + stringArray3[0]);
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- exception instantiating a new FruConfig class, e is <" + exception + ">"));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
        }
        replaceFRUBean.setInstalledEnclosureTypes(stringArray2);
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.getListOfEnclosureTypes()");
        return stringArray2;
    }

    private boolean is_a_supported_enclosure(String string, ReplaceFRUBean replaceFRUBean) {
        boolean bl;
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.is_a_supported_enclosure()");
            bl = true;
            String string2 = replaceFRUBean.getSelectedSystem();
            String string3 = string2.substring(0, 4);
            String string4 = string2.substring(5, 8);
            Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code is <" + string + ">"));
            Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string3 + "/" + string4));
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            stringArray[0] = string;
            try {
                FruConfig fruConfig = new FruConfig(string3, string4);
                try {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure location code to cross reference is: " + stringArray[0]));
                    stringArray2 = fruConfig.queryDescriptionsByLocation(stringArray, null);
                    if (stringArray2 != null && stringArray2.length > 0) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure <" + stringArray[0] + "> is supported"));
                        bl = true;
                        break block5;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure <" + stringArray[0] + "> is NOT supported"));
                    bl = false;
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- exception invoking queryDescriptionsByLocation(), ex is: " + exception));
                    Trace.trace((String)TRACE_MASKF, (Object)exception);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure <" + stringArray[0] + "> is NOT supported"));
                    bl = false;
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- exception instantiating a new FruConfig class, e is <" + exception + ">"));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
                Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure <" + stringArray[0] + "> is NOT supported"));
                bl = false;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.is_a_supported_enclosure()");
        return bl;
    }

    private String[] getValidFruTypes(String string, ReplaceFRUBean replaceFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.getValidFRUTypes()");
        String string2 = replaceFRUBean.getSelectedSystem();
        String string3 = string2.substring(0, 4);
        String string4 = string2.substring(5, 8);
        Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code is <" + string + ">"));
        Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string3 + "/" + string4));
        String[] stringArray = null;
        try {
            FruConfig fruConfig = new FruConfig(string3, string4);
            Map map = fruConfig.queryEnclosureFruInfo(string);
            Set set = map.keySet();
            Object[] objectArray = set.toArray();
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
                Trace.trace((String)TRACE_MASKF, (Object)("-- FRU description added was <" + stringArray[i] + ">"));
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is <" + exception + ">"));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.getValidFRUTypes()");
        return stringArray;
    }

    public void populateFRULocCodeTable(ReplaceFRUBean replaceFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.populateFRULocCodeTable");
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = replaceFRUBean.getSelectedSystem();
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 8);
        Trace.trace((String)TRACE_MASKF, (Object)("-- FruConfig input system type/model is " + string2 + "/" + string3));
        FruConfig fruConfig = new FruConfig(string2, string3);
        ArrayList arrayList2 = replaceFRUBean.getInstalledLocCodes();
        String string4 = replaceFRUBean.getInstalledEnclosures();
        int n = arrayList2.size();
        Trace.trace((String)TRACE_MASKF, (Object)("-- allLocCodesSize is <" + n + ">"));
        Integer[] integerArray = replaceFRUBean.getAllEnclosureIndexes();
        int n2 = integerArray.length;
        Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure type to search against is " + string4));
        String[] stringArray5 = null;
        String string5 = null;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList arrayList4 = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string6;
            Integer n3;
            block16: {
                n3 = integerArray[i];
                Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure index[" + i + "] value is " + n3));
                stringArray[0] = string6 = (String)arrayList2.get(n3);
                Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure index[" + i + "]'s locCode is " + string6));
                try {
                    stringArray5 = fruConfig.queryDescriptionsByLocation(stringArray, null);
                    string5 = stringArray5[0];
                    if (!string5.equals(string4)) break block16;
                    String string7 = null;
                    String string8 = null;
                    object3 = fruConfig.queryEnclosureFruInfo(string6);
                    Collection collection = (Collection)object3.get(replaceFRUBean.getSelectedFRU());
                    object2 = collection.iterator();
                    while (object2.hasNext()) {
                        object = (FruGuiInfo)object2.next();
                        string7 = object.getLocationSuffix();
                        string8 = object.getDesc();
                        if (string8.equals(replaceFRUBean.getSelectedFRU())) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- applicable suffix <" + string7 + "> found for FRU desc <" + string8 + ">"));
                            if (!arrayList.contains(string7)) {
                                arrayList.add(string7);
                            }
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)("-- valid FRU suffix to add: " + string7));
                    }
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- exception e: " + exception));
                    Trace.trace((String)TRACE_MASKF, (Object)exception);
                    continue;
                }
            }
            if (string5.equals(string4) && n3 < n) {
                int n4;
                Trace.trace((String)TRACE_MASKF, (Object)("-- current enclosure index is <" + n4 + ">"));
                boolean bl = false;
                for (n4 = n3 + 1; n4 < n && this.isCurrentIndexAFRU(n4, replaceFRUBean); ++n4) {
                    object3 = (String)replaceFRUBean.getInstalledLocCodes().get(n4);
                    int n5 = ((String)object3).indexOf("-");
                    object2 = ((String)object3).substring(n5 + 1);
                    object = (Integer)replaceFRUBean.getInstalledStatus().get(n4);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- possible FRU locCode is: <" + (String)object3 + ">"));
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- now looking for suffix <" + (String)arrayList.get(j) + ">..."));
                        if (((String)object2).equals((String)arrayList.get(j))) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- locCode/status of index[" + n4 + "] is: " + (String)object3 + "/" + object));
                            int n6 = (Integer)object & 0xC0;
                            if (n6 == 64) {
                                Trace.trace((String)TRACE_MASKF, (Object)"-- FRU present in selected enclosure - add to table");
                                arrayList3.add(object3);
                            } else if (n6 == 128) {
                                Trace.trace((String)TRACE_MASKF, (Object)"-- unknown if FRU present in selected enclosure - add to table");
                                arrayList3.add("*" + (String)object3);
                            } else {
                                Trace.trace((String)TRACE_MASKF, (Object)"-- FRU NOT present in selected enclosure - do not add to table");
                            }
                            bl = true;
                            continue;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)"-- current suffix not found");
                    }
                }
                if (!bl) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- FRU suffix NOT detected - add all suffixes to table");
                    for (int j = 0; j < arrayList.size(); ++j) {
                        arrayList3.add("*" + string6 + "-" + (String)arrayList.get(j));
                    }
                }
            }
            arrayList.clear();
        }
        replaceFRUBean.setFRUTableFRULocCodes(arrayList3);
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.populateFRULocCodeTable");
    }

    private boolean isCurrentIndexAFRU(int n, ReplaceFRUBean replaceFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.isCurrentIndexAFRU()");
        Trace.trace((String)TRACE_MASKF, (Object)("-- input index to verify against is: " + n));
        boolean bl = true;
        Integer[] integerArray = replaceFRUBean.getAllEnclosureIndexes();
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n2 = integerArray[i];
            int n3 = n2;
            Trace.trace((String)TRACE_MASKF, (Object)("-- next enclosure index is: " + n3));
            if (n3 == n) {
                bl = false;
                Trace.trace((String)TRACE_MASKF, (Object)"-- this index is an enclosure!");
                break;
            }
            if (n3 > n) break;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.isCurrentIndexAFRU()");
        return bl;
    }

    private void launchRepair(PanelTaskletResponse panelTaskletResponse, ReplaceFRUBean replaceFRUBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.launchRepair()");
        String string = replaceFRUBean.getSelectedSystem();
        Trace.trace((String)TRACE_MASKF, (Object)("-- input mtms data for R/V call is : " + string));
        ArrayList arrayList = replaceFRUBean.getPendingLocCodes();
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)arrayList.get(i);
                if (stringArray[i].startsWith("*")) {
                    stringArray[i] = stringArray[i].substring(1);
                }
                Trace.trace((String)TRACE_MASKF, (Object)("-- input locCode data for R/V call is : " + stringArray[i]));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("rvType", "REPLACE_FRU");
            hashMap.put("SYSTEM_MTMS", string);
            hashMap.put("LOCATIONS", stringArray);
            Trace.trace((String)TRACE_MASKF, (Object)"AddFRUTasklet.launchRepair() launching subtasklet com.ibm.hwmca.xfw.service.tasklet.RepairAndVerifyTasklet");
            try {
                ServiceActionDriverTasklet.taskletBugMap = hashMap;
                panelTaskletResponse.redirect(RV_TASKLET, hashMap);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception while launching redirect dialog, e is " + exception));
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-- pending enclosure locCode array is null");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.launchRepair()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceFRUTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 0, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceFRUTasklet.logException()");
    }
}

